
library(memisc)


library(mclogit)


load("model-churchat-cathprot-galtan-context.RData")


ls()


setCoefTemplate("horizontal.nostar"=t(c(est="($est:#)", se="(($se:#))")))


getCoefTemplate("horizontal.nostar")


m_galtan <- mtable(model_galtan,
                    coef.style="horizontal.nostar",
                    getSummary=getSummary.mmclogit,
                    gs.options=list(
                        rearrange=list(
                            "GAL--TAN" = c("Squared" = "galtan.sq",                        
                                                "Linear"  = "galtan",                           
                                                "$\\times$ attends rarely"      = "galtan:relattRarely",
                                                "$\\times$ attends on holidays" = "galtan:relattHolidays",
                                                "$\\times$ attends monthly"     = "galtan:relattMonthly",
                                                "$\\times$ attends weely"       = "galtan:relattWeekly",
                                                "$\\times$ Protestant"          = "galtan:cathprotProtestant",
                                                "$\\times$ attends rarely      $\\times$ Protestant"      = "galtan:relattRarely:cathprotProtestant",
                                                "$\\times$ attends on holidays $\\times$ Protestant"      = "galtan:relattHolidays:cathprotProtestant",
                                                "$\\times$ attends monthly     $\\times$ Protestant"      = "galtan:relattMonthly:cathprotProtestant",
                                                "$\\times$ attends weely       $\\times$ Protestant"      = "galtan:relattWeekly:cathprotProtestant",
                                                "$\\times$ self-employed"  = "galtan:oesch8Self-employed",       
                                                "$\\times$ technical"      = "galtan:oesch8Technical",           
                                                "$\\times$ management"     = "galtan:oesch8Management",          
                                                "$\\times$ clerks"         = "galtan:oesch8Clerks",              
                                                "$\\times$ socio-cultural" = "galtan:oesch8Socio-cultural",      
                                                "$\\times$ service worker" = "galtan:oesch8Service worker",      
                                                "$\\times$ primary sector" = "galtan:oesch8Primary sector",      
                                                "$\\times$ secularized"                  = "galtan:No_religion",
                                                "$\\times$ denominational balance"       = "galtan:Cath_Prot",
                                                "$\\times$ denominational heterogeneity" = "galtan:Denom_Het",
                                                "$\\times$ time" = "galtan:time", 
                                                "$\\times$ attends rarely      $\\times$ time"  = "galtan:relattRarely:time",
                                                "$\\times$ attends on holidays $\\times$ time"  = "galtan:relattHolidays:time",
                                                "$\\times$ attends weekly      $\\times$ time"  = "galtan:relattMonthly:time",
                                                "$\\times$ attends daily       $\\times$ time"  = "galtan:relattWeekly:time",
                                                "$\\times$ Protestant     $\\times$ time"  = "galtan:cathprotProtestant:time",
                                                "$\\times$ attends rarely      $\\times$ Protestant $\\times$ time"  = "galtan:relattRarely:cathprotProtestant:time",
                                                "$\\times$ attends on holidays $\\times$ Protestant $\\times$ time"  = "galtan:relattHolidays:cathprotProtestant:time",
                                                "$\\times$ attends monthly     $\\times$ Protestant $\\times$ time"  = "galtan:relattMonthly:cathprotProtestant:time",
                                                "$\\times$ attends weely       $\\times$ Protestant $\\times$ time"  = "galtan:relattWeekly:cathprotProtestant:time",
                                                "$\\times$ self-employed  $\\times$ time"  = "galtan:oesch8Self-employed:time",  
                                                "$\\times$ technical      $\\times$ time"  = "galtan:oesch8Technical:time",      
                                                "$\\times$ management     $\\times$ time"  = "galtan:oesch8Management:time",     
                                                "$\\times$ clerks         $\\times$ time"  = "galtan:oesch8Clerks:time",         
                                                "$\\times$ socio-cultural $\\times$ time"  = "galtan:oesch8Socio-cultural:time", 
                                                "$\\times$ service worker $\\times$ time"  = "galtan:oesch8Service worker:time", 
                                                "$\\times$ primary sector $\\times$ time"  = "galtan:oesch8Primary sector:time"),                                  
                            "Econ Left--Right"= c("Squared" = "lrecon.sq",
                                              "Linear"  = "lrecon",
                                              "$\\times$ attends rarely"      = "relattRarely:lrecon",
                                              "$\\times$ attends on holidays" = "relattHolidays:lrecon",
                                              "$\\times$ attends monthly"     = "relattMonthly:lrecon",
                                              "$\\times$ attends weely"       = "relattWeekly:lrecon",
                                              "$\\times$ Protestant"          = "cathprotProtestant:lrecon",
                                              "$\\times$ self-employed"  = "oesch8Self-employed:lrecon",       
                                              "$\\times$ technical"      = "oesch8Technical:lrecon",           
                                              "$\\times$ management"     = "oesch8Management:lrecon",          
                                              "$\\times$ clerks"         = "oesch8Clerks:lrecon",              
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:lrecon",      
                                              "$\\times$ service worker" = "oesch8Service worker:lrecon",      
                                              "$\\times$ primary sector" = "oesch8Primary sector:lrecon",      
                                              "$\\times$ time" = "time:lrecon", 
                                              "$\\times$ attends rarely      $\\times$ time"  = "relattRarely:time:lrecon",
                                              "$\\times$ attends on holidays $\\times$ time"  = "relattHolidays:time:lrecon",
                                              "$\\times$ attends weekly      $\\times$ time"  = "relattMonthly:time:lrecon",
                                              "$\\times$ attends daily       $\\times$ time"  = "relattWeekly:time:lrecon",
                                              "$\\times$ Protestant     $\\times$ time"  = "cathprotProtestant:time:lrecon",
                                              "$\\times$ self-employed  $\\times$ time"  = "oesch8Self-employed:time:lrecon",  
                                              "$\\times$ technical      $\\times$ time"  = "oesch8Technical:time:lrecon",      
                                              "$\\times$ management     $\\times$ time"  = "oesch8Management:time:lrecon",     
                                              "$\\times$ clerks         $\\times$ time"  = "oesch8Clerks:time:lrecon",         
                                              "$\\times$ socio-cultural $\\times$ time"  = "oesch8Socio-cultural:time:lrecon", 
                                              "$\\times$ service worker $\\times$ time"  = "oesch8Service worker:time:lrecon", 
                                              "$\\times$ primary sector $\\times$ time"  = "oesch8Primary sector:time:lrecon")
                        )))


m_galtan


m_galtan |> 
    relabel("Var(~(Const.)|CHES_id" = "Var(Party",
            "essround" = "ESS round",
            "CHES_id:" = "Party $\\times$ ",
            "Party x" = "Party $\\times$ ",
            "CHES_id" = "Party",
            fixed=TRUE,gsub=TRUE) |>
    toLatex() |> writeLines(con="churchat-context-galtan/mtable-churchat-cathprot-context-galtan.tex")




